jQuery(document).ready(function ($) {
	function rpress_add_fee( tip, type ) {
		var data = {
			action: 'rpress_add_tips',
			tip: tip,
			type: type
		};
		 $.ajax({
			type: "POST",
			data: data,
			dataType: "json",
			url: tips_script.ajaxurl,
			success: function (tips_response) {
				if ( tips_response.response == 'success' ) {
					if ( $('.rpress_cart_fee').length > 0 ) {
						$('#rpress_cart_fee_tip').remove();
						$(tips_response.html).insertAfter(".rpress_cart_fee").last();
					}
					else {
						$('.rpress_cart_fee').remove();

						$('.rpress-cart tbody').append(tips_response.html);
					}

					$('.rpress_cart_amount').each( function() {
							// Format tip amount for display.
							$( this ).text( tips_response.total );
							// Set data attribute to new (unformatted) tip amount.
							$( this ).data( 'total', tips_response.total_plan );
						} );

					$('.rpress-tips').find('.tip_percentage').text(tips_response.percentage + ' ' + tips_script.tip_type_symbol);
					
				}
			}
		}).fail(function (response) {
			if ( window.console && window.console.log ) {
				console.log( response );
			}
		}).done(function (response) {});
	}
	$(document).on('click', '.tips', function (e) {
		e.preventDefault();
		$('.tips').removeClass('active');
		$(this).addClass('active');
		$('#manual_tip_value').val('');
		rpress_add_fee( $(this).data('tip'), $(this).data('type') );
	});

	$('body').on('keyup', '#manual_tip_value', function (e) {
		$('.tips').removeClass('active');
		rpress_add_fee( $(this).val(), 'manual_tip_value' );
	});
});