<?php
/**
 * RP_Tips_Settings
 *
 * @package RP_Tips_Settings
 * @since 1.0
 */

defined( 'ABSPATH' ) || exit;

class RP_Tips_Settings {

  public function __construct() {
    
    add_filter( 'rpress_settings_general' , array( $this, 'rpress_tips_settings' ), 1, 1 );

  }


  /**
   * Set Tips in the Checkout setting tab
   * 
   * @param array links of settings array
   * @return array of settings link
   * @since 1.0
   */
  public function rpress_tips_settings( $settings ) {
    $settings['checkout_options']['enable_tips_on_checkout'] = array(
      'id'      => 'enable_tips_on_checkout',
      'name'    => __( 'Enable Tips on Checkout', 'restropress' ),
      'desc'    => __( 'Check this option to enable Tips on checkout page.', 'restropress' ),
      'type'    => 'checkbox',
    );
    $settings['checkout_options']['inculde_tax_on_tips'] = array(
      'id'      => 'inculde_tax_on_tips',
      'name'    => __( 'Include tax with total price to calculate.', 'restropress' ),
      'desc'    => __( 'Check this option to add tax on tips.', 'restropress' ),
      'type'    => 'checkbox',
    );
    $settings['checkout_options']['tips_text'] = array(
      'id'      => 'tips_text',
      'name'    => __( 'Tips text to be displayed on checkout', 'restropress' ),
      'type'    => 'text',
      'std'     => __( 'Tips', 'restropress' ),
    );
    $settings['checkout_options']['tips_type'] = array(
      'id'      => 'tips_type',
      'name'    => __( 'Choose your tips type', 'restropress' ),
      'type'    => 'radio',
      'options' => [ 'fixed_values' => 'Fixed Values', 'percentage_value' => 'Percentage Values' ],
      'std'     => 'percentage_value',
    );
    $settings['checkout_options']['tips_type_display'] = array(
      'id'      => 'tips_type_display',
      'name'    => __( 'Select how you want to display the tips', 'restropress' ),
      'type'    => 'radio',
      'options' => [ 'tips_options' => 'Select Tips Values only', 'manual_tips' => 'Custom Tips only', 'both' => 'Both' ],
      'std'     => 'both',
    );
    $settings['checkout_options']['tips_values'] = array(
      'id'    => 'tips_values',
      'name'  => __( 'Add Tip options.', 'restropress' ),
      'desc'  => __( 'Add the default tips you want to show on checkout. Add values separated by commas. eg. (10,15,20)', 'restropress' ),
      'type'  => 'text',
    );

    return $settings;
  }

  /**
   * Get tips html
   * @param $tip string Fee ID to be added
   * @return html
   **/
  function rpress_get_tips_html( $tip ) {

    // Get tip data
    $fee_id = $tip;
    $fees   = rpress_get_cart_fees();
    $fee  = $fees[$tip];
    ob_start();
    ?>
      <tr class="rpress_cart_fee" id="rpress_cart_fee_<?php echo $fee_id; ?>">
        <?php do_action( 'rpress_cart_fee_rows_before', $fee_id, $fee ); ?>

        <td colspan="3" class="rpress_cart_fee_label">
          <?php echo esc_html( $fee['label'] ); ?>
            <span>
              <?php echo esc_html( rpress_currency_filter( rpress_format_amount( $fee['amount'] ) ) ); ?>

              <?php if( ! empty( $fee['type'] ) && 'item' == $fee['type'] ) : ?>
            <a href="<?php echo esc_url( rpress_remove_cart_fee_url( $fee_id ) ); ?>"><?php _e( 'Remove', 'restropress' ); ?></a>
          <?php endif; ?>
            </span>
        </td>

        <?php do_action( 'rpress_cart_fee_rows_after', $fee_id, $fee ); ?>
      </tr>
    <?php
    return ob_get_clean();

  }

}
new RP_Tips_Settings();